//
//  TWCollectionViewCell.h
//  Twitch
//
//  Created by Auston Stewart on 10/29/13.
//  Copyright (c) 2013 Justin.tv. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface TWCollectionViewCell : UICollectionViewCell

+ (CGSize)cellSize;
- (void)loadImageAtURL:(NSString *)url fromCache:(TWCache *)cache persistently:(BOOL)persistently;

- (void)cacheDidDownloadResource:(NSNotification *)notification;
- (void)cacheDidNotDownloadResource:(NSNotification *)notification;

@property (nonatomic,copy) NSString *imageURL;
@property (nonatomic,copy) NSString *placeholderImageName;
@property (nonatomic,readwrite) BOOL shouldDownloadRedirectedImages;

@end
